function C = ellCaps( A, B, a, b, alpha, m, n, doPlot )
  [elems, nodes, fvIdx, pvIdx, pvals] ...
     = ellCoaxMesh( A, B, a, b, alpha, m, n );
  [S, T] = findST( elems, nodes );
  [U, W] = findUW( S, fvIdx, pvIdx, pvals );
  if( doPlot )
    meshplot( nodes, elems, 'ellmesh.ps' );
    writeSurface( 'ellval.dat', nodes, elems, U );
  end
  C = 2 * W;
