#ifndef _NUMINT_H_
#define _NUMINT_H_

/**
 *  Numerical integration routines
 */

#ifdef __cplusplus
extern "C" {
#endif

/**
 *    Composite Trapezoidal Rule Integration Function
 *     INPUTS:
 *           fn: Function to be integrated
 *           a, b: Limits of the integral
 *           n: Number of subdivisions of the interval
 */
double trapez( double (*fn)(double), double a, double b, int n );

/**
 *    Composite Simpson's Rule Integration Function
 *     INPUTS:
 *           fn: Function to be integrated
 *           a, b: Limits of the integral
 *           nhalf: Half the number of subdivisions of the interval
 */
double simpson( double (*fn)(double), double a, double b, int nhalf );

#ifdef __cplusplus
}
#endif
#endif /* !define(_NUMINT_H_) */
