#include "numint.h"

/**
 *    Composite Simpson's Rule Integration Function
 *     INPUTS:
 *           fn: Function to be integrated
 *           a, b: Limits of the integral
 *           nhalf: Half the number of subdivisions of the interval
 */
double simpson( double (*fn)(double), double a, double b, int nhalf )
{
  int i, n;
  double h, twoh, x;
  double sum1, sum2;

  n = 2 * nhalf;
  twoh = ( b - a ) / nhalf;
  h = twoh / 2.0;
  x = a + h;
  sum1 = (*fn)( x );
  sum2 = 0.0;
  for( i = 2; i < n; i+=2 ) {
    x += h;
    sum2 += (*fn)( x );
    x += h;
    sum1 += (*fn)( x );
  }
  return ( (*fn)( a ) + (*fn)( b ) + 4 * sum1 + 2 * sum2 ) * h / 3.0;
}
