#include "numint.h"

/**
 *    Composite Trapezoidal Rule Integration Function
 *     INPUTS:
 *           fn: Function to be integrated
 *           a, b: Limits of the integral
 *           n: Number of subdivisions of the interval
 */
double trapez( double (*fn)(double), double a, double b, int n )
{
  int i;
  double h, x, sum;

  h = ( b - a ) / n;
  sum = 0.5 * ( (*fn)( a ) + (*fn)( b ) );
  x = a;
  for( i = 1; i < n; i++ ) {
    x += h;
    sum += (*fn)( x );
  }
  sum *= h;
  return sum;
}
