C     Composite Trapezoidal Rule Integration Function
      DOUBLE PRECISION FUNCTION TRAPEZ( F, A, B, N )
C     INPUTS:
C             F: Function to be integrated
C             A, B: Limits of the integral
C             N: Number of subdivisions of the interval
      EXTERNAL F
      DOUBLE PRECISION F, A, B
      DOUBLE PRECISION H, X

      H = ( B - A ) / N
      TRAPEZ = 0.5 * ( F( A ) + F( B ) )
      X = A
      DO 11 I = 1, N-1
        X = X + H
        TRAPEZ = TRAPEZ + F( X )
   11 CONTINUE
      TRAPEZ = TRAPEZ * H
      END
