function S = simpson( fName, a, b, nhalf )
%
%   Composite Simpson's Rule Integration Function
%    INPUTS:
%          fName: Name of function to be integrated
%          a, b: Limits of the integral
%          nhalf: Half the number of subdivisions of the interval
%
  n = 2 * nhalf;
  twoh = ( b - a ) / nhalf;
  h = twoh / 2.0;
  x = a + h;
  S1 = feval( fName, x );
  S2 = 0.0;
  for k=1:(nhalf-1)
    x = x + h;
    S2 = S2 + feval( fName, x );
    x = x + h;
    S1 = S1 + feval( fName, x );
  end
  S = (feval(fName, a) + feval(fName, b) + 4*S1 + 2*S2) * h/3.0;
