function S = trapez( fName, a, b, n )
%   Composite Trapezoidal Rule Integration Function
%    INPUTS:
%          fName: Name of function to be integrated
%          a, b: Limits of the integral
%          n: Number of subdivisions of the interval
%
  h = ( b - a ) / n;
  S = 0.5 * ( feval( fName, a ) + feval( fName, b ) );
  x = a;
  for k=1:(n-1)
    x = x + h;
    S = S + feval( fName, x );
  end
  S = S * h;
