C     Composite Simpson's Rule Integration Function
      DOUBLE PRECISION FUNCTION SIMP( F, A, B, NHALF )
C     INPUTS:
C             F: Function to be integrated
C             A, B: Limits of the integral
C             NHALF: Half the number of subdivisions of the interval
      EXTERNAL F
      DOUBLE PRECISION F, A, B
      DOUBLE PRECISION H, TWOH, X
      DOUBLE PRECISION SUM1, SUM2

      N = 2 * NHALF
      TWOH = ( B - A ) / NHALF
      H = TWOH / 2
      X = A + H
      SUM1 = F( X )
      SUM2 = 0.0
      DO 11 I = 2, N-1, 2
        X = X + H
        SUM2 = SUM2 + F( X )
        X = X + H
        SUM1 = SUM1 + F( X )
   11 CONTINUE
      SIMP = ( F( A ) + F( B ) + 4 * SUM1 + 2 * SUM2 ) * H / 3.0d0
      END
