#ifndef __BST__
#define __BST__
#include <iostream>
#include <cstdlib>
#include <vector>

using namespace std;
/*
 * Node Declaration
 */
template<class T>
class node {
 private:
  T data;
  node<T> * left;
  node<T> * right;
	
 public:

 node(T data_) :
  data(data_), left(NULL), right(NULL) {
  }

  node * getLeft() {
    return left;
  }

  node * getRight() {
    return right;
  }
	
  int setLeft(node<T> * lft) {
    left = lft;
    return 0;
  }

  int setRight(node<T> * rgt) {
    right = rgt;
    return 0;
  }
	
  T getData() {
    return data;
  }

  int setData(T data_) {
    data = data_;
    return 0;
  }
	
};

 
/*
 * Class Declaration
 */
template<class T>
class BST {
 private:
  node<T> * root;
  unsigned int count = 0;
        
 public:
        
 BST() :root(NULL) { }
     
  void insert(T key);
  //bool remove(T key); // remove first occurence of key in tree
  bool search(T key); // returns true if key is present in tree
  unsigned int size() { return count;}

};

#endif
