#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <ctime>
#include <stdio.h>
#include "BST.h"
#include <vector>

using namespace std;

int main(int argc, char* argv[])
{
  ifstream file(argv[1]); // pass file name containing input numbers as argument
  std::string count_str(argv[2]); // pass a count of numbers to search for
  int count = stoi(count_str);
   
  // list to store the numbers from input file.
  std::vector<int> bst;

  string linebuffer;
  int num;

  //read file and populate the input list   
  while (file && getline(file, linebuffer)){
    if (linebuffer.length() == 0) continue;                
    num = stoi(linebuffer);
    bst.insert(num);
  }
  
  // search over BST for each input number
  for(int i=0; i<count; i++){
	std::string item_str(argv[3+i]);
	int item = stoi(search_str);
    
	clock_t begin = clock();
    bool found = bst.search(item);
    clock_t end = clock();
    double elapsed_secs = double(end - begin)*1000.0 / CLOCKS_PER_SEC;
    cout << "match," << item << "," << found << endl;
    cout << "time," << item << "," << elapsed_secs << endl;
  }
      
  return 0;
}
