#ifndef __PARENMATCH__
#define __PARENMATCH__
#include <string>
#include "LinkedList.h"
#include "Structures.h"
#include "List.h"
using namespace std;

// Parses each character in input string. Creates and return a list of Items. 
// Adds an item to list with its original start position, its type, and its value.
// Each value is a number, operator or parenthesis or brackets.
// Whitespace has to be skipped. If invalid char encountered, stop and return false.
// e.g. Input string "(10-[5 + 600])" should result in 9 items with <type,position,value> as:
// <1,0,(>  <4,1,10>  <3,3,->   <1,4,[>
// <4,5,5>  <3,7,+>   <4,9,600> <2,12,]>  <2,14,)>
// Input: String containing expression text from commandline
// Output: Pointer to head of list containing items parsed from the input string
bool toList(string, List<Item> *);

// Handles a left bracket/parenthesis item. Returns an Expression with the start position.
// Updates parenStack as necessary.
// Input: 
// (1) Position of bracket/parenthesis character and 
// (2) the actual bracket/parenthesis character
// Returns: Partially filled expression object for which this left bracket is the start.
Expression handleLeft(int, char);

// Handles a right bracket/parenthesis. 
// Updates and returns the expression that was matched with the start position.
// Input: 
// (1) Position of bracket/parenthesis character and 
// (2) the actual bracket/parenthesis character
// Output: Completely filled expression object for which this right bracket is the end.
// Return: True if this right bracket had a matching left bracket. False otherwise.
bool handleRight(int, char, Expression *);

// Handles a non-bracket/parenthesis item.
// Updates the Expression in parenStack as necessary.
// Input: String that is binary operator or positive number
// Output: true if expression was enclosed in a parenthesis/bracket. false otherwise.
bool handleExpr(string);

#endif
