#ifndef __STRUCTURES__
#define __STRUCTURES__

#include <cstddef>
#include <string>
#include <iostream>
#include <sstream>

using namespace std;

// Used to parse and store the input items that were read from commandline
struct Item {
	// 1:left parenthesis/bracket, 2:right parenthesis/bracket, 3:binary operator, 4:number
	int type;

	// Position in original input commandline, starting from 0
	int pos;

	// Value of the item: parenthesis/bracket, binary operator or number. Contiguous digits stored as a single number.
	string value;

	string tostring() {
		std::stringstream ss;
		ss << type << "," << pos << "," << value;
		return ss.str();
	}
};

struct Expression {
	// location of the left parenthesis/brackets
	int left;

	// location of the right parenthesis/brackets
	int right;

	// expression between (and including) parenthesis/brackets
	string expr;


	string tostring() {
		std::stringstream ss;
		ss << left << "," << right << "," << expr << endl;
		return ss.str();
	}
};

#endif
