#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <iostream>
#include "LinkedList.h"
#include "Stack.h"
#include "ParenMatch.h"
#include "Structures.h"
#include "List.h"
#include "global.h"

using namespace std;

// Global Variables
// maintain expressions seen so far for printing
Stack<Expression> exprStack;
// maintain outstanding left parenthesis or curly/square brackets
Stack<char> parenStack;

// reads an expression, and prints all expressions that fall between parenthesis/brackets,
// including the positions of the start and end brackets
int main(int argc, char *argv[]) {

	bool isWellFormed = true;
	// Valid inputs are non-negative integer, parenthesis or curly/square brackets,
	// one of the binary operators +-*/, or a whitespace
	char *input = argv[1];
	string strinput(input);

	// Populate items in list from input.
	// Returns true if only non-negative integer, parenthesis or curly/square brackets,
	// one of the binary operators +-*/, or a whitespace were present in the input
	List<Item> *list;
	list = (List<Item> *) malloc(sizeof(List<Item> ));

	bool parseValid = toList(strinput, list);

	// Check if input parsing was valid. Quit if not.
	if (!parseValid) {
		cout << "Invalid parse" << endl;
		return -1;
	}

	// Access each item, check for matching parenthesis, and print <start pos, end pos, expression>
	for (int i = 0; i < list->size(); i++) {

		Item item;
		list->get(i, &item);

		switch (item.type) {
		case 1: // process left parenthesis or curly/square brackets
		{
			Expression f;
			f = handleLeft(item.pos, item.value[0]);
			exprStack.push(f);
			break;
		}
		case 2: // process right parenthesis or curly/square brackets
		{
			Expression *f = new Expression;

			bool valid = handleRight(item.pos, item.value[0], f);

			// print Expression if valid
			if (valid) cout << f->tostring();
			else isWellFormed = false;
			break;
		}
		case 3:
		case 4:
			// process operator or integer
			handleExpr(item.value);
			break;
		default:
			cout << "INVALID!";
		}
	}

	if (!parenStack.isEmpty()) isWellFormed = false;

	cout << (isWellFormed ?
					"Given expression is well formed :-)" :
					"Given expression is not well formed :-(") << endl;
}

