#ifndef __LINKEDLIST__
#define __LINKEDLIST__
#include <cstddef>
#include <stdio.h>
template<class T>
class Node {
public:
	T DATA;
	Node<T> * NEXT;
public:
	Node(T data) :
			DATA(data), NEXT(NULL) {
	}
	Node * getNext() {
		return NEXT;
	}
	int setNext(Node<T> * next) {
		NEXT = next;
		return 0;
	}
	T getData() {
		return DATA;
	}
};

template<class T>
class LinkedList {
public:
	Node<T> * HEAD;

public:
	LinkedList() :
			HEAD(NULL) { }

	bool insertHead(T KEY);
	bool insertTail(T KEY);
	bool insertAt(T KEY, int k);

	bool deleteHead(T * KEY);
	bool deleteTail(T * KEY);
	bool deleteAt(T * KEY, int k);
	bool peekAt(T * KEY, int k);

	bool isEmpty();

	int size();
};

#endif
