/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import org.archive.format.gzip.GZIPConstants;
import org.archive.format.gzip.GZIPDecoder;
import org.archive.format.gzip.GZIPFormatException;
import org.archive.format.gzip.GZIPHeader;
import org.archive.format.gzip.GZIPSeriesMember;
import org.archive.streamcontext.Stream;

public class GZIPMemberSeries
extends InputStream
implements GZIPConstants {
    private static Logger LOG = Logger.getLogger(GZIPMemberSeries.class.getName());
    public static int STATE_DEFLATING = 0;
    public static int STATE_IOERROR = 1;
    public static int STATE_ALIGNED = 2;
    public static int STATE_SCANNING = 3;
    public static int STATE_START = 4;
    public int state = STATE_START;
    private String streamContext = null;
    private GZIPDecoder decoder = new GZIPDecoder();
    private GZIPHeader header = null;
    private static int BUF_SIZE = 4096;
    private Stream stream = null;
    private GZIPSeriesMember currentMember = null;
    private long currentMemberStartOffset = 0L;
    private boolean strict = false;
    private boolean gotEOF = false;
    private boolean gotIOError = false;
    private byte[] buffer = null;
    private byte[] singleByteRead = null;
    private int bufferPos = 0;
    private int bufferSize = 0;
    private long offset = 0L;

    public GZIPMemberSeries(Stream bis) {
        this(bis, "unknown");
    }

    public GZIPMemberSeries(Stream bis, String context) {
        this(bis, context, 0L, true);
    }

    public GZIPMemberSeries(Stream bis, String context, long offset) {
        this(bis, context, offset, true);
    }

    public GZIPMemberSeries(Stream bis, String context, long offset, boolean strict) {
        this.stream = bis;
        this.strict = strict;
        this.state = offset == 0L ? (strict ? STATE_ALIGNED : STATE_START) : STATE_START;
        this.buffer = new byte[BUF_SIZE];
        this.singleByteRead = new byte[1];
        this.currentMember = null;
        this.gotEOF = false;
        this.gotIOError = false;
        this.header = null;
        this.streamContext = context;
        this.offset = offset;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        this.gotEOF = true;
    }

    public boolean gotEOF() {
        return this.gotEOF;
    }

    public boolean gotIOError() {
        return this.gotIOError;
    }

    public String getStreamContext() {
        return this.streamContext;
    }

    public long getCurrentMemberStartOffset() {
        return this.currentMemberStartOffset;
    }

    public long getOffset() {
        return this.offset;
    }

    public void noteEndOfRecord() throws IOException {
        if (this.state != STATE_DEFLATING) {
            this.gotIOError = true;
            throw new IOException("noteEndOfRecord while not deflating at " + this.currentMemberStartOffset + " in " + this.streamContext);
        }
        this.state = STATE_ALIGNED;
    }

    public void noteGZError() throws IOException {
        LOG.info("noteGZError");
        if (this.strict) {
            this.gotIOError = true;
            this.state = STATE_IOERROR;
            throw new IOException("Internal GZIPFormatException " + this.currentMemberStartOffset + " in " + this.streamContext);
        }
        this.state = STATE_SCANNING;
    }

    /*
     * Unable to fully structure code
     */
    public GZIPSeriesMember getNextMember() throws GZIPFormatException, IOException {
        if (this.state == GZIPMemberSeries.STATE_IOERROR) {
            throw new IOException("getNextMember() on IOException Stream at " + this.currentMemberStartOffset + " in " + this.streamContext);
        }
        GZIPMemberSeries.LOG.info("getNextMember");
        if (this.gotEOF) {
            GZIPMemberSeries.LOG.info("getNextMember-ATEOF");
            return null;
        }
        if (this.state == GZIPMemberSeries.STATE_DEFLATING) {
            GZIPMemberSeries.LOG.info("getNextMember-without complete read - finishing current");
            try {
                this.currentMember.skipMember();
                GZIPMemberSeries.LOG.info("Skipped unfinished member");
            }
            catch (GZIPFormatException e) {
                GZIPMemberSeries.LOG.info("GZIPFormatException on skipMember()");
                if (!this.strict) ** GOTO lbl24
                throw new IOException("GZIPFormatException at " + this.offset + " in " + this.streamContext);
            }
        } else if (this.state == GZIPMemberSeries.STATE_SCANNING) {
            GZIPMemberSeries.LOG.warning("getNextMember() called when scanning - starting from " + (this.currentMemberStartOffset + 3L));
            this.offset = this.currentMemberStartOffset + 3L;
            this.bufferSize = 0;
            this.bufferPos = 0;
            this.stream.setOffset(this.currentMemberStartOffset + 3L);
        }
lbl24:
        // 5 sources

        this.currentMember = null;
        while (this.currentMember == null) {
            amtSkipped = this.decoder.alignOnMagic3(this);
            if (GZIPMemberSeries.LOG.isLoggable(Level.INFO)) {
                GZIPMemberSeries.LOG.info("AlignedResult:" + amtSkipped);
            }
            if (amtSkipped < 0L) {
                this.gotEOF = true;
                if (this.decoder.alignedAtEOF(amtSkipped)) {
                    GZIPMemberSeries.LOG.info("CleanEOF");
                    return null;
                }
                if (this.strict) {
                    throw new GZIPFormatException("Trailing bytes did notcontain a valid gzip member file: " + this.streamContext + " offset: " + this.currentMemberStartOffset);
                }
                if (GZIPMemberSeries.LOG.isLoggable(Level.INFO)) {
                    GZIPMemberSeries.LOG.info(String.format("Got EOF after %d bytes before finding magic in %s\n", new Object[]{amtSkipped * -1L, this.streamContext}));
                }
                return null;
            }
            if (amtSkipped > 0L) {
                if (this.strict) {
                    if (this.state == GZIPMemberSeries.STATE_START) {
                        GZIPMemberSeries.LOG.info(String.format("Strict mode Skipped %d bytes in (%s) before finding magic at offset(%d)\n", new Object[]{amtSkipped, this.streamContext, this.offset - 3L}));
                    } else {
                        throw new GZIPFormatException("Not aligned at gzip start: " + this.streamContext + " at offset " + (this.offset - 3L));
                    }
                }
                if (GZIPMemberSeries.LOG.isLoggable(Level.INFO)) {
                    GZIPMemberSeries.LOG.info(String.format("Skipped %d bytes in (%s) before finding magic at offset(%d)\n", new Object[]{amtSkipped, this.streamContext, this.offset - 3L}));
                }
            }
            try {
                this.currentMemberStartOffset = this.offset - 3L;
                this.header = this.decoder.parseHeader(this, true);
                GZIPMemberSeries.LOG.info("Read next GZip header...");
                this.currentMember = new GZIPSeriesMember(this, this.header);
                this.state = GZIPMemberSeries.STATE_DEFLATING;
            }
            catch (GZIPFormatException e) {
                if (this.strict) {
                    this.gotIOError = true;
                    throw new IOException(e + " at " + this.offset + " in " + this.streamContext);
                }
                this.offset = this.currentMemberStartOffset + 3L;
                this.stream.setOffset(this.currentMemberStartOffset + 3L);
                GZIPMemberSeries.LOG.warning(String.format("GZIPFormatException with record around offset(%d) in (%s)\n", new Object[]{this.offset, this.streamContext}));
            }
        }
        return this.currentMember;
    }

    @Override
    public int read() throws IOException {
        int amt = this.read(this.singleByteRead, 0, 1);
        if (amt == -1) {
            return -1;
        }
        return this.singleByteRead[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int amtWritten = 0;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("read(" + len + " bytes) bufferSize(" + this.bufferSize + ")");
        }
        while (len > 0) {
            if (this.bufferSize > 0) {
                int amtToCopy = Math.min(len, this.bufferSize);
                System.arraycopy(this.buffer, this.bufferPos, b, off, amtToCopy);
                this.bufferPos += amtToCopy;
                this.bufferSize -= amtToCopy;
                off += amtToCopy;
                len -= amtToCopy;
                amtWritten += amtToCopy;
                this.offset += (long)amtToCopy;
                continue;
            }
            if (this.fillBuffer()) continue;
        }
        if (amtWritten == 0) {
            return -1;
        }
        return amtWritten;
    }

    private boolean fillBuffer() throws IOException {
        try {
            int amtRead = this.stream.read(this.buffer, 0, this.buffer.length);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Underlying Stream read(" + amtRead + ") bytes");
            }
            if (amtRead == -1) {
                this.gotEOF = true;
                return false;
            }
            this.bufferPos = 0;
            this.bufferSize += amtRead;
        }
        catch (IOException e) {
            this.gotIOError = true;
            throw e;
        }
        return true;
    }

    public void returnBytes(int bytes) {
        if (bytes > this.bufferPos || bytes < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Returned (" + bytes + ")bytes");
        }
        this.bufferPos -= bytes;
        this.bufferSize += bytes;
        this.offset -= (long)bytes;
    }

    public int fillInflater(Inflater inflater) throws IOException {
        if (this.state != STATE_DEFLATING) {
            throw new IOException("fillInflater called while not deflating!");
        }
        if (this.bufferSize <= 0 && !this.fillBuffer()) {
            return -1;
        }
        inflater.setInput(this.buffer, this.bufferPos, this.bufferSize);
        this.bufferPos += this.bufferSize;
        this.offset += (long)this.bufferSize;
        int oldSize = this.bufferSize;
        this.bufferSize = 0;
        return oldSize;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

