/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.archive.io.BufferedSeekInputStream;
import org.archive.io.RandomAccessInputStream;
import org.archive.io.SeekInputStream;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;

public class ReplayInputStream
extends SeekInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 262144;
    private BufferedSeekInputStream diskStream;
    private byte[] buffer;
    private long position;
    private long size = -1L;
    protected long responseBodyStart = -1L;
    protected File backingFile;

    public ReplayInputStream(byte[] buffer, long size, long responseBodyStart, String backingFilename) throws IOException {
        this(buffer, size, backingFilename);
        this.responseBodyStart = responseBodyStart;
    }

    public ReplayInputStream(byte[] buffer, long size, String backingFilename) throws IOException {
        this.buffer = buffer;
        this.size = size;
        if (size > (long)buffer.length) {
            this.setupDiskStream(new File(backingFilename));
        }
    }

    protected void setupDiskStream(File backingFile) throws IOException {
        RandomAccessInputStream rais = new RandomAccessInputStream(backingFile);
        this.diskStream = new BufferedSeekInputStream(rais, 4096);
    }

    public ReplayInputStream(InputStream fillStream) throws IOException {
        this.buffer = new byte[262144];
        long count = ArchiveUtils.readFully(fillStream, this.buffer);
        if (fillStream.available() > 0) {
            this.backingFile = File.createTempFile("tid" + Thread.currentThread().getId(), "ris");
            count += FileUtils.readFullyToFile(fillStream, this.backingFile);
            this.setupDiskStream(this.backingFile);
        }
        this.size = count;
    }

    public void destroy() {
        IOUtils.closeQuietly((InputStream)this);
        if (this.backingFile != null) {
            FileUtils.deleteSoonerOrLater(this.backingFile);
        }
    }

    public long setToResponseBodyStart() throws IOException {
        this.position(this.responseBodyStart);
        return this.position;
    }

    @Override
    public int read() throws IOException {
        if (this.position == this.size) {
            return -1;
        }
        if (this.position < (long)this.buffer.length) {
            int c = this.buffer[(int)this.position] & 0xFF;
            ++this.position;
            return c;
        }
        int c = this.diskStream.read();
        if (c >= 0) {
            ++this.position;
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.position == this.size) {
            return -1;
        }
        if (this.position < (long)this.buffer.length) {
            int toCopy = (int)Math.min(this.size - this.position, Math.min((long)len, (long)this.buffer.length - this.position));
            System.arraycopy(this.buffer, (int)this.position, b, off, toCopy);
            if (toCopy > 0) {
                this.position += (long)toCopy;
            }
            return toCopy;
        }
        int read = this.diskStream.read(b, off, len);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    public void readFullyTo(OutputStream os) throws IOException {
        ReplayInputStream.readFullyTo(this, os);
    }

    public static void readFullyTo(InputStream in, OutputStream os) throws IOException {
        byte[] buf = new byte[4096];
        int c = in.read(buf);
        while (c != -1) {
            os.write(buf, 0, c);
            c = in.read(buf);
        }
    }

    public void readHeaderTo(OutputStream os) throws IOException {
        this.position = 0L;
        byte[] buf = new byte[(int)this.responseBodyStart];
        int c = this.read(buf, 0, buf.length);
        if (c != -1) {
            os.write(buf, 0, c);
        }
    }

    public void readContentTo(OutputStream os) throws IOException {
        this.setToResponseBodyStart();
        this.readFullyTo(os);
    }

    public void readContentTo(OutputStream os, long maxSize) throws IOException {
        this.setToResponseBodyStart();
        byte[] buf = new byte[4096];
        int c = this.read(buf);
        for (long tot = 0L; c != -1 && tot < maxSize; tot += (long)c) {
            os.write(buf, 0, c);
            c = this.read(buf);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.diskStream != null) {
            this.diskStream.close();
        }
    }

    public long getSize() {
        return this.size;
    }

    public long getHeaderSize() {
        return this.responseBodyStart;
    }

    public long getContentSize() {
        return this.size - this.responseBodyStart;
    }

    public long remaining() {
        return this.size - this.position;
    }

    public void position(long p) throws IOException {
        if (p < 0L) {
            throw new IOException("Negative seek offset.");
        }
        if (p > this.size) {
            throw new IOException("Desired position exceeds size.");
        }
        if (p < (long)this.buffer.length) {
            if (this.position > (long)this.buffer.length) {
                this.diskStream.position(0L);
            }
        } else {
            this.diskStream.position(p - (long)this.buffer.length);
        }
        this.position = p;
    }

    public long position() throws IOException {
        return this.position;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }
}

