/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.IOException;
import org.archive.io.SeekInputStream;

public class SafeSeekInputStream
extends SeekInputStream {
    private SeekInputStream input;
    private long expected;

    public SafeSeekInputStream(SeekInputStream input) throws IOException {
        this.input = input;
        this.expected = input.position();
    }

    private void ensure() throws IOException {
        if (this.expected != this.input.position()) {
            this.input.position(this.expected);
        }
    }

    @Override
    public int read() throws IOException {
        this.ensure();
        int c = this.input.read();
        if (c >= 0) {
            ++this.expected;
        }
        return c;
    }

    @Override
    public int read(byte[] buf, int ofs, int len) throws IOException {
        this.ensure();
        int r = this.input.read(buf, ofs, len);
        if (r > 0) {
            this.expected += (long)r;
        }
        return r;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        this.ensure();
        int r = this.input.read(buf);
        if (r > 0) {
            this.expected += (long)r;
        }
        return r;
    }

    @Override
    public long skip(long c) throws IOException {
        this.ensure();
        long r = this.input.skip(c);
        if (r > 0L) {
            this.expected += r;
        }
        return r;
    }

    public void position(long p) throws IOException {
        this.input.position(p);
        this.expected = p;
    }

    public long position() throws IOException {
        return this.expected;
    }
}

