#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <ctime>
#include <stdio.h>
#include "BST.h"
#include "Quick.h"
#include <vector>

using namespace std;

bool BSTsort(std::vector<int>, std::vector<int>&);
bool doTests(std::vector<int>, std::vector<int>, std::vector<int>);
int getSum(std::vector<int> list);
bool isSorted(std::vector<int> list);

int main(int argc, char* argv[])
{
  ifstream file(argv[1]); // pass file name as argument
  
  // list to store the numbers from input file.
  std::vector<int> list;
	
  string linebuffer;
  int num;

  //read file and populate the input list   
  while (file && getline(file, linebuffer)){
    if (linebuffer.length() == 0) continue;                
    num = stoi(linebuffer);
    list.push_back(num);
  }
  
  // call BST based sorting routine
  std::vector<int> bstsortedlist;
  bool success = BSTsort(list, bstsortedlist);

  // call quick sort routine
  std::vector<int> quicksortedlist;
  {
    clock_t begin = clock();
    QUICKsort(list, quicksortedlist);
    clock_t end = clock();
    double elapsed_secs = double(end - begin)*1000.0 / CLOCKS_PER_SEC;
    cout << "quick," << list.size() << "," << elapsed_secs << endl;
  }
  
  
  //checking if the lists returned by BST and QUICK sort are both sorted or not    
  cout << (success && doTests(list, bstsortedlist, quicksortedlist) ? "Sorting is successful :-)" : "Sorting failed :-(") << endl;        
    
  return 0;
}


bool BSTsort(std::vector<int> list, std::vector<int>& bstsortedlist)
{

  clock_t begin = clock();
  BST<int> bst;
  
  // insertion into BST from the input list      
  for (unsigned int i = 0; i < list.size(); i++) {
    bst.insert(list[i]);
  }

  // sanity check
  if(bst.size() != list.size()) {
    cout << "insert size error 1, " << list.size() << "<>" << bst.size() << endl;
    return false;
  }

  //perform inorder traversal and insert into output list...will be in sorted order
  bst.inorder(bstsortedlist);

  clock_t end = clock();
  double elapsed_secs = double(end - begin)*1000.0 / CLOCKS_PER_SEC;
  cout << "bst," << list.size() << "," << elapsed_secs << endl;
  
  // remove items from BST, sanity check
  
  for (unsigned int i = 0; i < list.size(); i++) {
    
    bst.remove(list[i]);
    if(bst.size() != (list.size() - i - 1)) {
      cout << "remove size error 1, " << (list.size() - i - 1) << "<>" << bst.size() << " after " << list[i] << endl;
      return false;
    }
  }

  return true;
}



bool doTests(std::vector<int> list, std::vector<int> bstsortedlist, std::vector<int> quicksortedlist)
{
  // check if the list sizes match
  if(list.size() != bstsortedlist.size()) {
    cout << "count error 1, " << list.size() << "<>" << bstsortedlist.size() << endl;
    return false;
  }
  if(list.size() != quicksortedlist.size()) {
    cout << "count error 2, " << list.size() << "<>" << quicksortedlist.size() << endl;
    return false;
  }

  // check if the list sums match
  int sum1 = getSum(list);
  int sum2 = getSum(bstsortedlist);
  int sum3 = getSum(quicksortedlist);
  if(sum1 != sum2) {
    cout << "sum error 1" << endl;
    return false;
  }
  if(sum1 != sum3) {
    cout << "sum error 2" << endl;
    return false;
  }
	
  // Check if the lists ar sorted
  if(!isSorted(bstsortedlist)) {
    cout << "sort error 1" << endl;
    return false;
  }
  if(!isSorted(bstsortedlist)) {
    cout << "sort error 2" << endl;
    return false;
  }
	
  return true;
}

int getSum(std::vector<int> list){
  int sum = 0;
  for(unsigned int i=0; i<list.size(); i++){
    sum+=list[i];
  }
  return sum;
}

bool isSorted(std::vector<int> list)
{
  if(list.size() == 0 || list.size() == 1) return true;

  for(unsigned int i = 0; i<list.size()-1; i++) {
    if(list[i] > list[i+1]) return false;
  }

  return true;
}
