/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.archive.format.gzip.GZIPConstants;
import org.archive.format.gzip.GZIPFormatException;
import org.archive.util.ByteOp;

public class GZIPFExtraRecord
implements GZIPConstants {
    private byte[] name = null;
    private byte[] value = null;

    public GZIPFExtraRecord() {
    }

    public GZIPFExtraRecord(byte[] name, long intVal) throws GZIPFormatException {
        if (name.length != 2) {
            throw new GZIPFormatException("FExtra name is 2 bytes");
        }
        this.name = name;
        this.value = new byte[4];
        ByteOp.writeInt(this.value, 0, intVal);
    }

    public GZIPFExtraRecord(byte[] name, byte[] value) throws GZIPFormatException {
        if (name.length != 2) {
            throw new GZIPFormatException("FExtra name is 2 bytes");
        }
        if (value != null && value.length > 65536) {
            throw new GZIPFormatException("FExtra value max is 65536 bytes");
        }
        this.name = name;
        this.value = value;
    }

    public boolean matchesName(byte[] name) {
        if (name == null) {
            return false;
        }
        if (this.name == null) {
            return false;
        }
        return ByteOp.cmp(this.name, name);
    }

    public byte[] getName() {
        return this.name;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public int length() {
        if (this.name == null) {
            return 0;
        }
        if (this.value == null) {
            return 4;
        }
        return 4 + this.value.length;
    }

    public void writeTo(byte[] buf, int offset) {
        if (buf.length - offset < this.length()) {
            throw new IndexOutOfBoundsException();
        }
        buf[offset + 0] = this.name[0];
        buf[offset + 1] = this.name[1];
        if (this.value == null) {
            ByteOp.writeShort(buf, offset + 2, 0);
        } else {
            ByteOp.writeShort(buf, offset + 2, this.value.length);
            System.arraycopy(this.value, 4, buf, offset + 2, this.value.length);
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        if (this.name == null || this.value == null) {
            return;
        }
        os.write(this.name);
        if (this.value == null) {
            ByteOp.writeShort(os, 0);
        } else {
            ByteOp.writeShort(os, this.value.length);
            os.write(this.value);
        }
    }

    public int read(InputStream is, int maxRead) throws IOException {
        byte[] tmpName = null;
        byte[] tmpVal = null;
        int valLen = 0;
        tmpName = ByteOp.readNBytes(is, 2);
        valLen = ByteOp.readShort(is);
        if (valLen > maxRead - 2 - 2) {
            tmpVal = ByteOp.readNBytes(is, maxRead - 2 - 2);
            throw new GZIPFormatException.GZIPExtraFieldShortException(maxRead);
        }
        if (valLen > 0) {
            tmpVal = ByteOp.readNBytes(is, valLen);
        }
        this.name = tmpName;
        this.value = tmpVal;
        return 4 + valLen;
    }

    public int read(byte[] buf, int offset) throws GZIPFormatException, IOException {
        byte[] tmpName = null;
        byte[] tmpVal = null;
        int valLen = 0;
        int remaining = buf.length - offset;
        if (remaining < 4) {
            throw new GZIPFormatException("Short bytes for FExtra field");
        }
        tmpName = ByteOp.copy(buf, offset, 2);
        valLen = ByteOp.bytesToShort(buf, offset + 2);
        remaining += 0;
        if (valLen > 0) {
            if (valLen > remaining) {
                throw new GZIPFormatException("Short bytes for FExtra value");
            }
            tmpVal = ByteOp.copy(buf, offset + 4, valLen);
        }
        this.name = tmpName;
        this.value = tmpVal;
        return 4 + valLen;
    }
}

