/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.gzip;

import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import org.archive.format.gzip.GZIPFExtraRecord;
import org.archive.format.gzip.GZIPFooter;
import org.archive.format.gzip.GZIPHeader;
import org.archive.format.gzip.GZIPSeriesMember;
import org.archive.format.gzip.GZIPStaticHeader;
import org.archive.resource.MetaData;
import org.archive.resource.ResourceConstants;
import org.archive.util.ByteOp;
import org.json.JSONException;
import org.json.JSONObject;

public class GZIPMetaData
extends MetaData
implements ResourceConstants {
    private static final Logger LOG = Logger.getLogger(GZIPMetaData.class.getName());

    public GZIPMetaData(MetaData parentMetaData) {
        super(parentMetaData, "Gzip-Metadata");
    }

    public void setData(GZIPSeriesMember member) {
        try {
            GZIPHeader header = member.getHeader();
            GZIPStaticHeader staticH = header.getStaticHeader();
            if (staticH.isFNameSet()) {
                this.putString("Filename", new String(header.getFileName(), "UTF-8"));
            }
            if (staticH.isFCommentSet()) {
                this.putLong("Comment-Length", header.getCommentLength());
            }
            if (staticH.isFHCRCSet()) {
                this.putLong("Header-CRC", header.getHeaderCRC());
            }
            int records = header.getRecordCount();
            for (int i = 0; i < records; ++i) {
                GZIPFExtraRecord rec = header.getRecord(i);
                JSONObject recJO = new JSONObject();
                String name = new String(rec.getName(), "UTF-8");
                recJO.put("Name", (Object)name);
                if (name.equals("SL") || name.equals("LX")) {
                    recJO.put("Value", ByteOp.bytesToInt(rec.getValue()));
                } else {
                    recJO.put("Value", (Object)ByteOp.drawHex(rec.getValue()));
                }
                this.appendChild("F-Extra", recJO);
            }
            this.putLong("Deflate-Length", member.getCompressedBytesRead());
            this.putLong("Header-Length", header.getLength());
            this.putLong("Footer-Length", 8L);
            GZIPFooter footer = member.getFooter();
            this.putLong("Inflated-CRC", footer.getCRC());
            this.putLong("Inflated-Length", footer.getLength());
        }
        catch (UnsupportedEncodingException e) {
            LOG.warning(e.getMessage());
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
        }
    }
}

