/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.warc;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.archive.io.ArchiveReader;
import org.archive.io.warc.WARCReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARCFileRecordReader
extends RecordReader<Text, ArchiveReader> {
    private String arPath;
    private ArchiveReader ar;
    private FSDataInputStream fsin;
    private boolean hasBeenRead = false;

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit split = (FileSplit)inputSplit;
        Configuration conf = context.getConfiguration();
        Path path = split.getPath();
        FileSystem fs = path.getFileSystem(conf);
        this.fsin = fs.open(path);
        this.arPath = path.getName();
        this.ar = WARCReaderFactory.get((String)path.getName(), (InputStream)this.fsin, (boolean)true);
    }

    public void close() throws IOException {
        this.fsin.close();
        this.ar.close();
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return new Text(this.arPath);
    }

    public ArchiveReader getCurrentValue() throws IOException, InterruptedException {
        return this.ar;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.hasBeenRead ? 1.0f : 0.0f;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.hasBeenRead) {
            return false;
        }
        this.hasBeenRead = true;
        return true;
    }
}

