/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.archive.util.TextUtils;

public class PropertyUtils {
    protected static String propRefPattern = "\\$\\{([^{}]+)\\}";

    public static String getPropertyOrNull(String key) {
        String value = System.getProperty(key);
        return value == null || value.length() <= 0 ? null : value;
    }

    public static boolean getBooleanProperty(String key) {
        return PropertyUtils.getPropertyOrNull(key) == null ? false : Boolean.valueOf(PropertyUtils.getPropertyOrNull(key));
    }

    public static int getIntProperty(String key, int fallback) {
        return PropertyUtils.getPropertyOrNull(key) == null ? fallback : Integer.parseInt(PropertyUtils.getPropertyOrNull(key));
    }

    public static String interpolateWithProperties(String original) {
        return PropertyUtils.interpolateWithProperties(original, System.getProperties());
    }

    public static String interpolateWithProperties(String original, Properties ... props) {
        Matcher m;
        String result = original;
        for (int i = 0; i < original.length() * 2 && (m = TextUtils.getMatcher(propRefPattern, result)).find(); ++i) {
            Properties properties;
            String key = m.group(1);
            String value = "";
            Properties[] arr$ = props;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !StringUtils.isNotEmpty((String)(value = (properties = arr$[i$]).getProperty(key, ""))); ++i$) {
            }
            result = result.substring(0, m.start()) + value + result.substring(m.end());
        }
        return result;
    }
}

