package in.ac.iisc.cds.se256.alpha.twitter;

import java.io.IOException;

import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.log4j.Logger;

/**
 * 
 * @author simmhan
 *
 */
public class TwitterTopoCounterReduce {
	private static final Logger LOG = Logger.getLogger(TwitterTopoCounterReduce.class);
	protected static enum REDUCERCOUNTER {
		EDGES, VERTICES,
		EXCEPTIONS
	}
	
	/**
	 * Reduce function that counts the number of vertices and edges 
	 * @author simmhan
	 *
	 */
	protected static class TwitterTopoCounterReducer extends Reducer<Text, LongWritable, Text, LongWritable> {

		private long vertexCount; // state
		private Text outKeyEdgeCount = new Text("E");
		private LongWritable outValEdgeCount = new LongWritable(0);
		private Text outKeyVertexCount = new Text("VERTEX_COUNT");
		private LongWritable outValVertexCount = new LongWritable(0);
		
		@Override
		protected void setup(Context context) throws IOException, InterruptedException {
			vertexCount = 0;
		}
		
		@Override
	    public void reduce(Text key, Iterable<LongWritable> values, Context context) {
			try{
				// if key is 'E', get count of values and emit
				if("E".equals(key.toString())) {
					long edgeCount = 0;
					for(LongWritable l : values) edgeCount+=l.get();
					outValEdgeCount.set(edgeCount);
					context.write(outKeyEdgeCount, outValEdgeCount);
					context.getCounter(REDUCERCOUNTER.EDGES).increment(1);
				} else { // increment vertexCount
					vertexCount++;
					context.getCounter(REDUCERCOUNTER.VERTICES).increment(1);
				}
			}
			catch (Exception ex) {
				LOG.error("Caught Exception", ex);
				context.getCounter(REDUCERCOUNTER.EXCEPTIONS).increment(1);
			}
		}
		@Override
		protected void cleanup(Context context) throws IOException, InterruptedException {
			if(vertexCount > 0) {
				outValVertexCount.set(vertexCount);
				context.write(outKeyVertexCount, outValVertexCount);
			}
		}
	}	
}
