package in.ac.iisc.cds.se256.alpha.twitter;

import java.io.IOException;

import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.log4j.Logger;

/**
 * 
 * @author simmhan
 *
 */
public class TwitterTopoCounterMap {
	private static final Logger LOG = Logger.getLogger(TwitterTopoCounterMap.class);
	protected static enum MAPPERCOUNTER {
		RECORDS_IN,
		EXCEPTIONS
	}
	
	/**
	 * Map function that counts the number of vertices and edges 
	 * @author simmhan
	 *
	 */
	protected static class TwitterTopoCounterMapper extends Mapper<LongWritable, Text, Text, LongWritable> {
		private Text outKeyVertex = new Text();
		private Text outKeyEdgeCount = new Text("E");
		
		private LongWritable outValVertex = new LongWritable(0);
		private LongWritable outValEdgeCount = new LongWritable(1);

		@Override
		public void map(LongWritable key, Text value, Context context) throws IOException {
			try{
				String[] vertexPair = value.toString().split("\\s+");
				if(vertexPair.length != 2) throw new Exception("Vertex input format not correct: '"+value+"' did not have 2 tokens:"+vertexPair.length);
				
				Long source = Long.parseLong(vertexPair[0]);
				Long sink = Long.parseLong(vertexPair[0]);
				
				// Write 2 keys, one for source vertex ID and another for destination vertex ID, with value 0
				outKeyVertex.set(source.toString());
				context.write(outKeyVertex, outValVertex);
				outKeyVertex.set(sink.toString());
				context.write(outKeyVertex, outValVertex);
				
				// write unit value for edge
				context.write(outKeyEdgeCount, outValEdgeCount);
			}
			catch (Exception ex) {
				LOG.error("Caught Exception", ex);
				context.getCounter(MAPPERCOUNTER.EXCEPTIONS).increment(1);
			}
		}
	}
	
	protected static class TwitterTopoCounterPartitioner extends Partitioner<Text, LongWritable> {

		@Override
		public int getPartition(Text key, LongWritable value, int numPartitions) {
			if("E".equals(key.toString())) return 0; // return first reducer for edges
			else return numPartitions-1; // return last reducer for vertices
		}		
	}
}
